<?php
require __DIR__ . '/../vendor/autoload.php';

use Dotenv\Dotenv;
use GuzzleHttp\Client;

$dotenv = Dotenv::createImmutable(__DIR__ . '/../');
$dotenv->load();

$shop = $_GET['shop'] ?? null;
$code = $_GET['code'] ?? null;

if (!$shop || !$code) {
	// Geçersiz dönüş
	die("Invalid callback parameters");
}

$client = new Client();

$response = $client->post("https://{$shop}/admin/oauth/access_token", [
	'form_params' => [
		'client_id' => $_ENV['SHOPIFY_API_KEY'],
		'client_secret' => $_ENV['SHOPIFY_API_SECRET'],
		'code' => $code,
	]
]);

$body = json_decode($response->getBody(), true);
$accessToken = $body['access_token'] ?? null;

if (!$accessToken) {
	// Token alınamadı
	die("Token could not be obtained");
}

// Basit test için dosyaya kaydedelim (gerçekte DB kullanmalısın)
file_put_contents(__DIR__ . "/../logs/token.txt", "{$shop}|{$accessToken}\n", FILE_APPEND);

// App başarıyla yüklendi! Access token alındı.
echo "App installed successfully! Access token obtained.";
