<?php
require __DIR__ . '/../vendor/autoload.php';

use Dotenv\Dotenv;

$dotenv = Dotenv::createImmutable(__DIR__ . '/../');
$dotenv->load();

$shop = $_GET['shop'] ?? null;

if (!$shop) {
	die("Shop parameter is required (?shop=example.myshopify.com)");
}

$params = [
	"client_id" => $_ENV['SHOPIFY_API_KEY'],
	"scope" => $_ENV['SHOPIFY_SCOPES'],
	"redirect_uri" => $_ENV['SHOPIFY_REDIRECT_URI'],
	"state" => bin2hex(random_bytes(12)),
];

$query = http_build_query($params);
$url = "https://{$shop}/admin/oauth/authorize?{$query}";

header("Location: $url");
exit;
