<?php
require __DIR__ . '/../vendor/autoload.php';

use Shopify\Clients\Rest as ShopifyRestClient;

class ShopifyClient {
	private $client;

	public function __construct($shop, $accessToken) {
		$this->client = new ShopifyRestClient($shop, $accessToken);
	}

	public function getProducts() {
		return $this->client->get('products')->getDecodedBody();
	}

	public function createProduct($data) {
		return $this->client->post('products', ['product' => $data])->getDecodedBody();
	}
}
